﻿<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="System.ComponentModel" %>
<%@ import Namespace="System.Diagnostics" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Zestawienie dla GUS DG-1</title>
		<script runat="server">
		
            //Jeżeli ustawiony true, to wszystkie liczby podawane bez zaokrąglenia
            static bool debug = false;

            //Po ustawieniu na true raport zostanie przygotowany dla pracowników zwróconych
            //przez listę a nie dla wszystkich
            static bool wglisty = false;	
		
            static string traceName = "";

    public class Params: ContextBase {
    
        public Params(Context context): base(context) {
            miesiac = new YearMonth(Date.Today);
            miesiac -= 1;
        }
    
        YearMonth miesiac;
        [Required]
        [Priority(1)]
        public YearMonth ZaMiesiąc {
            get { return miesiac; }
            set {
                miesiac = value;
                OnChanged(EventArgs.Empty);
            }
        }    
    }
    
    Params pars;
    [Context]
    public Params Pars {
        get { return pars; }
        set { pars = value; }
    }

    class Total {
        public readonly FromTo rok;
        public readonly FromTo miesiąc;

        public int osobyMies;
        Time pracaRok;

        public decimal bruttoMies;
        public decimal skrMies;
        public decimal zusMies;
        public decimal fisMies;
        
        public decimal bruttoRok;
        public decimal skrRok;
        public decimal zusRok;
        public decimal fisRok;
    
        decimal[] wymiar = new decimal[12];
        int[] days = new int[12];
    
        public Total(YearMonth ym) {
            rok = new FromTo(new Date(ym.Year, 1, 1), ym.LastDay);
            miesiąc = ym.ToFromTo();

            int y = ym.Year;
            for (int m=1; m<=12; m++) {
                YearMonth c = new YearMonth(y, m);
                days[m-1] = c.Days;
            }
        }
    
        //Do etatów wliczamy pracowników (bez uczniów, chałupników, agentów i pracowników
        //zatrudnionych za granicą) --> RodzajZatrudnienia=Nie dotyczy
        //Pomijamy okresy urlopów bezpłatnych.

        public void AddEtaty(PracHistoria ph, KalkulatorPracy kalk, Periods eoz) {
            //-->Bez agentów, chałupników, uczniów
            if (ph.Etat.RodzajZatrudnienia!=RodzajZatrudnienia.NieDotyczy && ph.Etat.RodzajZatrudnienia!=RodzajZatrudnienia.PracownikTymczasowy)
                return;
    
            FromTo zatr = ph.Etat.EfektywnyOkres * rok;
            if (zatr==FromTo.Empty)
                return;

			if (kalk!=null)
				pracaRok += kalk.Praca(zatr).Czas;
				
            decimal w = (decimal)ph.Etat.Zaszeregowanie.Wymiar;
            Periods p = zatr.ToPeriods() * eoz;
            p = p.BreakByMonth();
            foreach (FromTo o in p) {
                int m = o.From.Month-1;
                wymiar[m] += (w * o.Days) / days[m];
            }
			
            SubTable elementy = new SubTable(ph.Pracownik.Elementy, zatr);
            foreach (WypElement e in elementy)
                if (e.Definicja.Info.Opodatkowany 
                    && !WypElement.Zasiłek.Eval(e) 
                    && e.Wyplata.Typ==TypWyplaty.Etat
                    && e.Definicja.GUS.WykazujNaDeklaracjach
                ) {
                    bruttoRok += e.Wartosc;
                    bool skr = e.Definicja.GUS.Kategoria==KategoriaWynagrodzeniaGUS.WypłataUdziałWZysku;
                    if (skr)
						skrRok += e.Wartosc;
                    zusRok += e.Podatki.KosztyZUS;
                    //TID: 3997
                    //fisRok += e.Podatki.ZalFIS + e.Podatki.ZdrowotneFaktycznieOdliczon e;
                    fisRok += e.Podatki.NalFIS;
                    if (miesiąc.Contains(e.Okres.To)) {
						bruttoMies += e.Wartosc;
						if (skr)
							skrMies += e.Wartosc;
						zusMies += e.Podatki.KosztyZUS;
                        //TID: 3997
                        //fisMies += e.Podatki.ZalFIS + e.Podatki.ZdrowotneFaktycznieOdliczon e;
                        fisMies += e.Podatki.NalFIS;
                        Trace(e.Definicja + " " + e.Okres + " " + e.Wartosc);
                    }
                }
        }

        public void AddOsoby(Pracownik p) {
            PracHistoria ph = p[miesiąc.To];
            if (ph.GUS.GlowneMiejscePracy && ph.Etat.EfektywnyOkres.Contains(miesiąc.To))
                switch (ph.Etat.RodzajZatrudnienia) {
                    case RodzajZatrudnienia.NieDotyczy:
                    case RodzajZatrudnienia.PracownikTymczasowy:
                    case RodzajZatrudnienia.PracownikZaGranicą:
                    case RodzajZatrudnienia.PracownikTymczasowyZaGranicą:
                    case RodzajZatrudnienia.CzłonekRSP:
                    case RodzajZatrudnienia.CzłonekSKR:
                    case RodzajZatrudnienia.Chałupnik:
                    case RodzajZatrudnienia.Właściciel:
                    case RodzajZatrudnienia.OsobaWspółpracująca:
                        //Agent
                        if (!Nieobecny(ph.Pracownik, miesiąc.To))
                            osobyMies++;
                        break;
                }
        }

        protected static bool Nieobecny(Pracownik pracownik, Date data) {
            KalkulatorPracy kp = new KalkulatorPracy(pracownik);
            FromTo okres = new FromTo((new YearMonth(data) - 2).FirstDay, (new YearMonth(data) + 3).LastDay);

            Periods on = Periods.Empty;
            Periods on2 = Periods.Empty;
            foreach (INieobecnosc n in kp.Nieobecnosci(okres, false))
                switch (n.Definicja.Przyczyna) {
                    case PrzyczynaNieobecnosci.UrlopWychowawczy:
                    case PrzyczynaNieobecnosci.UrlopWychowawczyZUS:
                        on2 += n.Okres; //W Z-06 wychowawcze co najmniej 3 miesiące
                        break;
                    case PrzyczynaNieobecnosci.UrlopBezpłatny:
                        on += n.Okres;
                        break;
                    case PrzyczynaNieobecnosci.UrlopRehabilitacyjny:
                        if (n.Zwolnienie.Przyczyna != PrzyczynaZwolnienia.UrlopRehabilitacyjnyCiąża)
                            on2 += n.Okres;
                        break;
                    case PrzyczynaNieobecnosci.SłużbaWojskowa:
                        //Tylko na Z-06
                        //on2 += n.Okres;
                        break;
                }

            //Nieobecności 'każdy dzień'
            if (on2[data] != FromTo.Empty)
                return true;

            on = on.ToFlat();
            okres = on[data];
            if (okres == FromTo.Empty)
                return false;
            StazPracy sp = new StazPracy(okres, pracownik).Normalizuj();
            return sp.Lata > 0 || sp.Miesiace > 2;
        }
                    
        decimal EtatyOkres(int from, int to) {
            decimal w = 0;
            decimal m = to - from + 1;
            for (int i=from-1; i<to; i++)
                w += wymiar[i];
            w /= m;
            return w;
        }
        
        public decimal EtatyMies {
            get {
                decimal w = EtatyOkres(rok.To.Month, rok.To.Month);
                return System.Math.Round(w, debug ? 2 : 0);
            }
        }

        public decimal EtatyRok {
			get { 
                decimal w = EtatyOkres(1, rok.To.Month);
                return System.Math.Round(w, debug ? 2 : 0);
            }
        }
    		
        public decimal Czas {
            get {
                decimal t = (decimal)pracaRok.TotalHours;
                if (debug)
                    return t;
                return Soneta.Tools.Math.Round(t / 1000, 1);
            }
        }
	}

    public decimal Tys(decimal value) {
        if (debug)
            return value;
        return Soneta.Tools.Math.Round(value / 1000, 1);
    }

    static Log trace;
    	    
    void dc_ContextLoad(Object sender, EventArgs e) {
        trace = null;
        if (traceName != "")
            trace = new Log(traceName, true);
        
        ReportHeader["MIESIĄC"] = pars.ZaMiesiąc.ToString();
        
        bool czas = (pars.ZaMiesiąc.Month%3)==0;
                
        Total t = new Total(pars.ZaMiesiąc);
        KadryModule kadry = KadryModule.GetInstance(dc);
        Log log = new Log();
        int m;
        int l = 0;

        IEnumerable pracownicy;
        if (wglisty) {
            ArrayList lista = new ArrayList();
            foreach (Pracownik idx in (Row[])dc[typeof(Row[])])
                lista.Add(idx);
            pracownicy = lista;
            m = lista.Count;
        }
        else {
            Soneta.Business.View view = kadry.Pracownicy.CreateView();
            view.ForceAllRows();
            m = view.Count;
            pracownicy = view;
        }

        foreach (Pracownik p in pracownicy) {
            Trace(p);
            log.WriteLine(new Percent(++l, m));
            log.WriteLine(p);
            using (trace == null ? null : trace.IncrementIndent()) {
                KalkulatorPracy kalk = new KalkulatorPracy(p);
                Periods eoz = EfektywnyOkresZatrudnienia(p, kalk, t.rok);
                foreach (PracHistoria ph in p.Historia.GetIntersectedRows(t.rok)) {
                    t.AddEtaty(ph, czas ? kalk : null, eoz);
                }
                t.AddOsoby(p);
            }
        }
        
        osobyMies.EditValue = t.osobyMies;
                
        etatyMies.EditValue = t.EtatyMies;
        etatyRok.EditValue = t.EtatyRok;
        
        pracaRok.EditValue = czas ? t.Czas.ToString() : "&nbsp;";
        
        bruttoMies.EditValue = Tys(t.bruttoMies);
        bruttoRok.EditValue = Tys(t.bruttoRok);
        
        skrMies.EditValue = Tys(t.skrMies);
        skrRok.EditValue = Tys(t.skrRok);
        
        zusMies.EditValue = Tys(t.zusMies);
        zusRok.EditValue = Tys(t.zusRok);
        
        pitMies.EditValue = Tys(t.fisMies);
        pitRok.EditValue = Tys(t.fisRok);       
    }

    static Periods EfektywnyOkresZatrudnienia(Pracownik pracownik, KalkulatorPracy kalk, FromTo okres) {
        //Wyliczamy okres zatrudnienia w bieżącym miesiącu
        Periods okrzatr = Periods.Empty;
        foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(okres))
            okrzatr += ph.Etat.EfektywnyOkres;
        okrzatr *= okres;

        Periods on = Periods.Empty;
        foreach (INieobecnosc n in kalk.Nieobecnosci(okres, false))
            switch (n.Definicja.Przyczyna) {
                case PrzyczynaNieobecnosci.UrlopBezpłatny:
                    on += n.Okres;
                    break;
            }

        okrzatr -= on;
        return okrzatr.ToFlat();
    }

		        
    static void Msg(object value) {
    }

            static void Trace(object value) {
                if (trace != null)
                    trace.WriteLine(value == null ? "(null)" : value.ToString());
            }
		        
		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="Form1" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:datacontext><eb:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" title="Zestawienie dla GUS DG-1|Meldunek o działalności gospodarczej|</strong>Za miesiąc: <strong>%MIESIĄC%" runat="server"></eb:reportheader>
			<font style="font-family: Verdana; font-size: 11px; font-weight: bold">Dział 1. Podstawowe dane o działalności gospodarczej</font>
				<TABLE id="Table1" cellSpacing="0" cellPadding="0" width="100%" border="1" 
                    
                style="border-collapse: collapse; font-family: Verdana; font-size: 11px;">
					<TR>
						<TD style="WIDTH: 486px" width="486" colSpan="3">
							<P align="center">Wyszczególnienie</P>
						</TD>
						<TD width="20%">
							<P align="center">W miesiącu sprawozdawczym</P>
						</TD>
						<TD>
							<P align="center">Od początku roku do końca miesiąca sprawozdawczego</P>
						</TD>
					</TR>
					<TR>
						<TD style="WIDTH: 486px; HEIGHT: 13px" width="486" colSpan="3">
							<P align="center"><FONT size="2">0</FONT></P>
						</TD>
						<TD style="HEIGHT: 13px" width="20%">
							<P align="center"><FONT size="2">1</FONT></P>
						</TD>
						<TD style="HEIGHT: 13px">
							<P align="center"><FONT size="2">2</FONT></P>
						</TD>
					</TR>
					<TR>
						<TD width="56%" colSpan="2" height="42">Pracujący w osobach stan w ostatnim dniu 
							miesiąca</TD>
						<TD height="42">
							<P align="center">06</P>
						</TD>
						<TD width="20%" height="42">
							<P align="right"><ea:datalabel id="osobyMies" runat="server"></ea:datalabel></P>
						</TD>
						<TD height="42">
							<P align="right">&nbsp;</P>
						</TD>
					</TR>
					<TR>
						<TD colSpan="2" height="42">Przeciętna liczba zatrudnionych</TD>
						<TD height="42">
							<P align="center">07</P>
						</TD>
						<TD height="42">
							<P align="right"><ea:datalabel id="etatyMies" runat="server"></ea:datalabel></P>
						</TD>
						<TD height="42">
							<P align="right"><ea:datalabel id="etatyRok" runat="server"></ea:datalabel></P>
						</TD>
					</TR>
					<TR>
						<TD colSpan="2" height="42">Czas przepracowany w tyś. godź. (wypełnić za miesiąc: 
							III, VI, IX, XII - podając dane za okres od początku roku)</TD>
						<TD height="42">
							<P align="center">08</P>
						</TD>
						<TD height="42">
							<P align="right">&nbsp;</P>
						</TD>
						<TD height="42">
							<P align="right"><ea:datalabel id="pracaRok" runat="server"></ea:datalabel></P>
						</TD>
					</TR>
					<TR>
						<TD colSpan="2" height="42">Wynagrodzenie brutto osób wykazanych w wierszu 07 w 
							tyś. zł</TD>
						<TD height="42">
							<P align="center">09</P>
						</TD>
						<TD height="42">
							<P align="right">
								<ea:DataLabel id="bruttoMies" runat="server"></ea:DataLabel></P>
						</TD>
						<TD height="42">
							<P align="right">
								<ea:DataLabel id="bruttoRok" runat="server"></ea:DataLabel></P>
						</TD>
					</TR>
					<TR>
						<TD width="10%" height="42" rowSpan="3">z&nbsp;wiersza<BR>
							09 przypa-<BR>
							da na</TD>
						<TD height="42">wypłaty z tytułu udziału w zysku lub nadwyżce<BR>
							bilansowej w spółdzielniach</TD>
						<TD style="WIDTH: 23px" height="42">
							<P align="center">10</P>
						</TD>
						<TD height="42">
							<P align="right"><ea:datalabel id="skrMies" runat="server"></ea:datalabel></P>
						</TD>
						<TD height="42">
							<P align="right"><ea:datalabel id="skrRok" runat="server"></ea:datalabel></P>
						</TD>
					</TR>
					<TR>
						<TD height="42">składki na ubezpieczenie emerytalne, rentowe i chorobowe opłacane 
							przez ubezpieczonych</TD>
						<TD style="WIDTH: 23px" height="42">
							<P align="center">11</P>
						</TD>
						<TD height="42">
							<P align="right"><ea:datalabel id="zusMies" runat="server"></ea:datalabel></P>
						</TD>
						<TD height="42">
							<P align="right"><ea:datalabel id="zusRok" runat="server"></ea:datalabel></P>
						</TD>
					</TR>
					<TR>
						<TD height="42">podatek dochodowy od osób fizycznych (przed odliczeniem składki na 
							powszechne ubezpieczenie zdrowotne)</TD>
						<TD style="WIDTH: 23px" height="42">
							<P align="center">12</P>
						</TD>
						<TD height="42">
							<P align="right"><ea:datalabel id="pitMies" runat="server"></ea:datalabel></P>
						</TD>
						<TD height="42">
							<P align="right"><ea:datalabel id="pitRok" runat="server"></ea:datalabel></P>
						</TD>
					</TR>
				</TABLE>
			<eb:reportfooter id="ReportFooter" runat="server" TheEnd="False"></eb:reportfooter>
		</form>
	</body>
</HTML>
